#include <iostream>
#include <vector>
#include <algorithm>

struct pokusaj {
    unsigned milj;
    unsigned broj;
};

bool stepenDv(unsigned num) {
    return (num & (num - 1)) == 0;
}

void promeniBracket(std::vector<unsigned>& snage, const int milj, int izmene) {
    std::sort(snage.begin(), snage.end(), [milj](unsigned a, unsigned b) {
        return (a == milj) ? false : ((b == milj) ? true : a > b);
    });

    for (int i = 0; i < izmene; ++i) {
        std::swap(snage[i % (snage.size() - 1)], snage[(i + 1) % (snage.size() - 1)]);
    }
}
int simRunde(std::vector<unsigned> snage, const pokusaj& trenPokusaj) {
    int milj = snage[trenPokusaj.milj - 1];
    int izmene = trenPokusaj.broj;
    int runda = 0;
    int n = snage.size();

    promeniBracket(snage, milj, izmene);

    while (n > 0) {
        runda++;
        std::cout << "RUNDA: " << runda << std::endl;
        for (int i = 0; i < n; i += 2) {

            if (n == 1) return runda;

            int igrac1 = i;
            int igrac2 = i + 1;
            std::cout << "IGRAC: " << snage[igrac1] << " PROTIV IGRAC: " << snage[igrac2] << std::endl;
            if (snage[igrac1] >= snage[igrac2]) {
                std::cout << "POBEDIO: " << snage[igrac1] << std::endl;
                if (snage[igrac2] == milj) return runda;
                snage[i / 2] = snage[igrac1];
            }
            else {
                std::cout << "POBEDIO: " << snage[igrac2] << std::endl;
                if (snage[igrac1] == milj) return runda;
                snage[i / 2] = snage[igrac2];
            }
        }
        n /= 2;
    }
}

int main() {

    unsigned n, brpokusaja;

    std::cin >> n;
    if (!stepenDv(n)) return 1;

    std::vector<unsigned> snage(n);

    for (auto& x : snage) std::cin >> x;

    std::cin >> brpokusaja;
    if (brpokusaja == 0) return 1;

    std::vector<pokusaj> pokusaji(brpokusaja);

    for (auto& x : pokusaji) {
        std::cin >> x.milj >> x.broj;
    }

    for (int i = 0; i < brpokusaja; i++) {
        int rundaMilj = simRunde(snage, pokusaji[i]);
        std::cout << rundaMilj << std::endl;
    }

    return 0;
}